﻿using System;

public class PatientImageAnalysis
{
    public bool? ImagesInCprsFlag { get; private set; }
    public bool? FragmentVerifiedFlag { get; private set; }
    public bool? BoneFractureDocumentedFlag { get; private set; }
    public bool? FragmentsInJointSpaceFlag { get; private set; }
    public int? StandardImageFragmentSizeId { get; private set; }
    public string JointSpace { get; private set; }
    public string OtherObservations { get; private set; }
    public DateTime? DateReviewed { get; private set; }

    public PatientImageAnalysis(
        bool? imagesInCprsFlag,
        bool? fragmentVerifiedFlag,
        bool? boneFractureDocumentedFlag,
        bool? fragmentsInJointSpaceFlag,
        int? standardImageFragmentSizeId,
        string jointSpace,
        string otherObservations,
        DateTime? dateReviewed)
    {
        ImagesInCprsFlag = imagesInCprsFlag;
        FragmentVerifiedFlag = fragmentVerifiedFlag;
        BoneFractureDocumentedFlag = boneFractureDocumentedFlag;
        FragmentsInJointSpaceFlag = fragmentsInJointSpaceFlag;
        StandardImageFragmentSizeId = standardImageFragmentSizeId;
        JointSpace = jointSpace;
        OtherObservations = otherObservations;
        DateReviewed = dateReviewed;
    }
}